﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Animation;
using System.Windows.Shapes;

using System.IO.IsolatedStorage;
using System.IO;

namespace Signature
{
    public partial class Page : UserControl
    {
        private bool MouseDown = false;
        private Point _previouspoint;
        private List<Point> _points;
        private List<List<Point>> _lines = new List<List<Point>>();
	
        public Page()
        {
            InitializeComponent();
			//---przypisanie metod obsługi zdarzeń---
            SigPad.MouseLeftButtonDown += new
                MouseButtonEventHandler(SigPad_MouseLeftButtonDown);
            SigPad.MouseLeftButtonUp += new
                MouseButtonEventHandler(SigPad_MouseLeftButtonUp);
            SigPad.MouseMove += new
                MouseEventHandler(SigPad_MouseMove);
				
			//---przypisanie metod obsługi zdarzeń---
			btnSave.MouseLeftButtonDown += new 			
			    MouseButtonEventHandler(btnSave_MouseLeftButtonDown);
			btnLoad.MouseLeftButtonDown += new 
			    MouseButtonEventHandler(btnLoad_MouseLeftButtonDown);
			btnClear.MouseLeftButtonDown += new 
			    MouseButtonEventHandler(btnClear_MouseLeftButtonDown);
        }
		
		//---uruchamiane jest w momencie, gdy użytkownik naciśnie przycisk myszy---
		void SigPad_MouseLeftButtonDown(
		    object sender, MouseButtonEventArgs e)
	    {
		    //---zapisanie, że naciśnięto lewy przycisk myszy---
			MouseDown = true;
			
			//---tworzenie nowych obiektów _points i _lines, co których
			//   zapisane zostaną rysowane punkty---
			_points = new List<Point>();
			
			//---zapisanie aktualnego punktu---
			_previouspoint = e.GetPosition(SigPad);
			
			//---dodanie punktu do listy---
			_points.Add(_previouspoint);
		}
		
		//---uruchamiane jest w momencie, gdy użytkownik puści przycisk myszy---
		void SigPad_MouseLeftButtonUp(
		    object sender, MouseButtonEventArgs e)
	    {
		    //---użytkownik puścił przycisk myszy---
			MouseDown = false;
			
			//---dodawanie do listy ostatniego punktu aktualnej linii---
			_lines.Add(_points);
		}
		
		//---uruchamiane przy poruszaniu wskaźnika myszy---
		void SigPad_MouseMove(object sender, MouseEventArgs e)
		{
		    //---jeżeli naciśnięty jest lewy przycisk myszy---
			if (MouseDown)
			{
			    //---dodanie aktualnego punktu---
				var currentPoint = e.GetPosition(SigPad);
				_points.Add(currentPoint);
				
				//---rysowanie linii łączącej poprzedni punkt z aktualnym---
				Line line = new Line()
				{
				    X1 = _previouspoint.X,
					Y1 = _previouspoint.Y,
					X2 = currentPoint.X,
					Y2 = currentPoint.Y,
					StrokeThickness = 2,
					Stroke = new SolidColorBrush(Colors.Black)
				};
				
				//---dodawanie linii do kontrolki podpisu---
				SigPad.Children.Add(line);
				
				//---zapisanie aktualnego punktu---
				_previouspoint = currentPoint;
			}
		}
		
		//---zwraca podpis w postaci serii linii---
		private string GetSignatureLines()
		{
		    System.Text.StringBuilder sb = new
			    System.Text.StringBuilder();
			//---jeden obieg na każdą linię---
			for (int i = 0; i <= _lines.Count - 1; i++)
			{
			    //---jeden obieg na każdy punkt---
				foreach (Point pt in _lines[i])
				{
				    sb.Append(pt.X + "," + pt.Y + "|");
				}
				sb.Append("\n");
			}
			return sb.ToString();
		}
		
		//---przycisk Zapisz---
		void btnSave_MouseLeftButtonDown(
		    object sender, MouseButtonEventArgs e)
		{
            ////---zapisanie podpisu---
            //IsolatedStorageFile isoStore =
            //    IsolatedStorageFile.GetUserStoreForApplication();
			
            //IsolatedStorageFileStream isoStream =
            //    new IsolatedStorageFileStream("IsoStoreFile.txt",
            //        FileMode.Create, isoStore);
			
            //StreamWriter writer = new StreamWriter(isoStream);
            ////---zapisanie linii do pliku---
            //writer.Write(GetSignatureLines());
            //txtStatus.Text = "Podpis został zapisany!";
			
            //writer.Close();
            //isoStream.Close();

            try
            {
                ServiceReference1.WebServiceSoapClient ws = new
                    Signature.ServiceReference1.WebServiceSoapClient();

                //---przypisanie metody obsługi zdarzenia zakończenia pracy przez metodę usługi sieciowej---
                ws.SaveSignatureCompleted += new
                    EventHandler<Signature.ServiceReference1.
                    SaveSignatureCompletedEventArgs>(ws_SaveSignatureCompleted);

                //---wywołanie metody z usługi sieciowej---
                ws.SaveSignatureAsync(GetSignatureLines());
            }
            catch (Exception ex)
            {
                txtStatus.Text = ex.ToString();
            }
		}

        void ws_SaveSignatureCompleted(
            object sender,
            Signature.ServiceReference1.SaveSignatureCompletedEventArgs e)
        {
            txtStatus.Text = "Podpis został wysłany do usługodawcy!";
        }
		
		//---rysowanie podpisu---
		private void DrawSignature(string value)
		{
		    _lines = new List<List<Point>>();
			
			//---podzielenie ciągu znaków na poszczególne linie---
			string[] lines = value.Split('\n');
			
			//---jeden obieg na każdą linię---
			for (int i = 0; i <= lines.Length - 2; i++)
			{
			    //---podzielenie na poszczególne punkty---
				string[] ps = lines[i].Split('|');
				_points = new List<Point>();
				
				//---jeden obieg na każdy punkt---
				for (int j = 0; j <= ps.Length - 2; j++)
				{
				    string[] xy = ps[j].Split(',');
					_points.Add(new Point(
					    (Convert.ToDouble(xy[0])),
						 Convert.ToDouble(xy[1])));
				}
				_lines.Add(_points);
			}
			
			//---rysowanie podpisu---
			for (int line = 0; line <= _lines.Count - 1; line++)
			{
			    _points = (List<Point>)_lines[line];
				for (int i = 1; i <=_points.Count - 1; i++)
				{
				    Line sline = new Line()
					{
					    X1 = _points[i - 1].X,
						Y1 = _points[i - 1].Y,
						X2 = _points[i].X,
						Y2 = _points[i].Y,
						StrokeThickness = 2,
						Stroke = new SolidColorBrush(Colors.Black)
					};
			    SigPad.Children.Add(sline);
				}
			}
		}
		
		//---przycisk Załaduj---
		void btnLoad_MouseLeftButtonDown(
		    object sender, MouseButtonEventArgs e)
		{
            //IsolatedStorageFile isoStore =
            //    IsolatedStorageFile.GetUserStoreForApplication();
			
            //IsolatedStorageFileStream isoStream =
            //    new IsolatedStorageFileStream("IsoStoreFile.txt",
            //        FileMode.Create, isoStore);
			
            //StreamReader reader = new StreamReader(isoStream);
            ////---odczytanie wszystkich linii z pliku---
            //string lines = reader.ReadToEnd();
			
            ////---rysowanie podpisu---
            //DrawSignature(lines);
            //txtStatus.Text = "Podpis został odczytany!";
			
            //reader.Close();
            //isoStream.Close();

            try
            {
                ServiceReference1.WebServiceSoapClient ws = new
                    Signature.ServiceReference1.WebServiceSoapClient();

                //---przypisanie metody obsługi zdarzenia zakończenia pracy przez metodę usługi sieciowej---
                ws.GetSignatureCompleted += new
                    EventHandler<Signature.ServiceReference1.
                    GetSignatureCompletedEventArgs>(ws_GetSignatureCompleted);

                //---wywołanie metody z usługi sieciowej---
                ws.GetSignatureAsync();
            }
            catch (Exception ex)
            {
                txtStatus.Text = ex.ToString();
            }
		}

        void ws_GetSignatureCompleted(
            object sender,
            Signature.ServiceReference1.GetSignatureCompletedEventArgs e)
        {
            txtStatus.Text = "Podpis został pobrany od usługodawcy!";
            DrawSignature(e.Result);
        }

		//---przycisk Wyczyść---
		void btnClear_MouseLeftButtonDown(
		    object sender, MouseButtonEventArgs e)
		{
			_lines = new List<List<Point>>();
			_points = new List<Point>();
			
			//---iteracyjne usuwanie wszystkich linii podpisu---
			int totalChild = SigPad.Children.Count - 2;
			for (int i = 0; i <= totalChild; i++)
			{
				SigPad.Children.RemoveAt(1);
			}
			
			txtStatus.Text = "Podpis został wyczyszczony!";
		}
    }
}
